<?php
/**
 * The template to display the car's single page
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.6.25
 */

wp_enqueue_script('jquery-ui-accordion', false, array('jquery', 'jquery-ui-core'), null, true);
if (trx_addons_get_option('cars_single_style') == 'tabs')
	wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);

get_header();

while ( have_posts() ) { the_post();
	$trx_addons_meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);
	?>
	<article id="post-<?php the_ID(); ?>" <?php post_class( 'cars_page itemscope' ); ?>
		itemscope itemtype="http://schema.org/Article">
		
		<section class="cars_page_section cars_page_header"><?php
			// Image
			if ( !trx_addons_sc_layouts_showed('featured') && has_post_thumbnail() ) {
				?><div class="cars_page_featured"><?php
					the_post_thumbnail( trx_addons_get_thumb_size('huge'), array(
								'alt' => get_the_title(),
								'itemprop' => 'image'
								)
							);
				// Price
				if (!empty($trx_addons_meta['price']) || !empty($trx_addons_meta['price2'])) {
					?><div class="cars_page_title_price"><?php
						trx_addons_get_template_part('cpt/cars/tpl.cars.parts.price.php',
														'trx_addons_args_cars_price',
														array('meta' => $trx_addons_meta)
													);
					?></div><?php
				}
				?></div><?php
				if (!empty($trx_addons_meta['gallery'])) {
					$trx_addons_gallery = explode('|', $trx_addons_meta['gallery']);
					if (is_array($trx_addons_gallery)) {
						?><div class="cars_page_gallery"><?php
							foreach($trx_addons_gallery as $trx_addons_image) {
								if ($trx_addons_image != '') {
									$trx_addons_thumb = trx_addons_get_attachment_url($trx_addons_image, trx_addons_get_thumb_size('tiny'));
									$trx_addons_image = trx_addons_get_attachment_url($trx_addons_image, trx_addons_get_thumb_size('huge'));
									if (!empty($trx_addons_thumb)) {
										$attr = trx_addons_getimagesize($trx_addons_thumb);
										?><span class="cars_page_gallery_item" data-image="<?php echo esc_url($trx_addons_image); ?>"><?php
											?><img src="<?php echo esc_url($trx_addons_thumb); ?>" alt="<?php esc_attr__('Image', 'grab-taxi')?>"<?php
												if (!empty($attr[3])) echo ' '.trim($attr[3]);
											?>><?php
										?></span><?php
									}
								}
							}
						?></div><?php
					}
				}
			}
			
			// Title
			if ( true || !trx_addons_sc_layouts_showed('title') ) {
				?><div class="cars_page_title_wrap">
					<h3 class="cars_page_title">
						<?php the_title(); ?>
						<span class="cars_page_status"><?php
							trx_addons_show_layout(trx_addons_get_post_terms('', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_STATUS));
						?></span>
					</h3>
					<?php
					// Meta
					?><div class="cars_page_title_meta"><?php
						// Counters
						trx_addons_sc_show_post_meta('cars_single', apply_filters('trx_addons_filter_show_post_meta', array(
									'components' => 'counters,share',
									'counters' => 'views,comments,likes',
									'seo' => false
									), 'cars_single', 1)
								);
					?></div><?php
					trx_addons_sc_layouts_showed('postmeta', true);
					
					

					// Post content
					?><section id="<?php echo esc_attr($trx_addons_tabs_id.'_description'); ?>_content" class="cars_page_section cars_page_content entry-content" itemprop="articleBody"><?php
						if (trx_addons_get_option('cars_single_style') == 'tabs') {
							?><h4 class="cars_page_section_title"><?php echo esc_html($trx_addons_section_titles['description']); ?></h4><?php
						}
						the_content( );
					?></section><!-- .entry-content --><?php
				?></div><?php
			}
		?></section><?php

		
		// Section's titles
		$trx_addons_section_titles = array(
			'description' => esc_html__('Description', 'grab-taxi'),
			'details' => esc_html__('Details', 'grab-taxi'),
			'features' => esc_html__('Features', 'grab-taxi'),
			'attachments' => esc_html__('Attachments', 'grab-taxi'),
			'video' => esc_html__('Video', 'grab-taxi'),
			'contacts' => esc_html__('Contacts', 'grab-taxi')
		);
		$trx_addons_tabs_id = 'cars_page_tabs';

		// Tabs
		if (trx_addons_get_option('cars_single_style') == 'tabs') {
			?><div class="trx_addons_tabs cars_page_tabs">
				<ul class="trx_addons_tabs_titles"><?php
					foreach ($trx_addons_section_titles as $trx_addons_section_slug => $trx_addons_section_title) {
						$trx_addons_tab_id = $trx_addons_tabs_id.'_'.$trx_addons_section_slug;
						$trx_addons_tab_active = trx_addons_get_value_gp('tab')==$trx_addons_section_slug
										? ' data-active="true"' 
										: '';
						?><li<?php
							if (trx_addons_get_value_gp('tab')==$trx_addons_section_slug)
								echo ' data-active="true"';
							?>><a href="<?php echo esc_url(trx_addons_get_hash_link('#'.$trx_addons_tab_id.'_content')); ?>"><?php
								echo esc_html($trx_addons_section_title);
							?></a></li><?php
					}
				?></ul><?php
		}


		// Details
		?><section id="<?php echo esc_attr($trx_addons_tabs_id.'_details'); ?>_content" class="cars_page_section cars_page_details">
			<h4 class="cars_page_section_title"><?php echo esc_html($trx_addons_section_titles['details']); ?></h4>
			<?php
			// ID
			if (!empty($trx_addons_meta['id'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Car ID:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php trx_addons_show_layout($trx_addons_meta['id']); ?></span>
				</span><?php
			}
			// Maker
			?><span class="cars_page_section_item">
				<span class="cars_page_label"><?php esc_html_e('Maker:', 'grab-taxi'); ?></span>
				<span class="cars_page_data"><?php
					trx_addons_show_layout(trx_addons_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_MAKER));
				?></span>
			</span><?php
			// Model
			?><span class="cars_page_section_item">
				<span class="cars_page_label"><?php esc_html_e('Model:', 'grab-taxi'); ?></span>
				<span class="cars_page_data"><?php
					trx_addons_show_layout(trx_addons_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_MODEL));
				?></span>
			</span><?php
			// Transmission
			if (!empty($trx_addons_meta['transmission'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Transmission:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout(trx_addons_get_option_title(TRX_ADDONS_CPT_CARS_PT, 'transmission', $trx_addons_meta['transmission']));
					?></span>
				</span><?php
			}
			// Fuel
			if (!empty($trx_addons_meta['fuel'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Fuel:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout(trx_addons_get_option_title(TRX_ADDONS_CPT_CARS_PT, 'fuel', $trx_addons_meta['fuel']));
					?></span>
				</span><?php
			}
			// Engine
			if (!empty($trx_addons_meta['engine_size']) || !empty($trx_addons_meta['engine_type'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Engine:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout($trx_addons_meta['engine_size']
											 . ($trx_addons_meta['engine_size_prefix'] 
														? ' ' . trx_addons_prepare_macros($trx_addons_meta['engine_size_prefix'])
														: '')
											 . ($trx_addons_meta['engine_type'] 
														? ' ' . trx_addons_prepare_macros($trx_addons_meta['engine_type'])
														: '')
											);
					?></span>
				</span><?php
			}
			// Engine power in horses
			if (!empty($trx_addons_meta['engine_power_horses'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Engine power:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout($trx_addons_meta['engine_power_horses'] . ' ' . esc_html__('horses', 'grab-taxi'));
					?></span>
				</span><?php
			}
			// Engine power in watts
			if (!empty($trx_addons_meta['engine_power_wt'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Engine power:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout($trx_addons_meta['engine_power_wt'] . ' ' . esc_html__('watts', 'grab-taxi'));
					?></span>
				</span><?php
			}
			// Doors
			if (!empty($trx_addons_meta['doors'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Doors:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout($trx_addons_meta['doors']
											 . ($trx_addons_meta['doors_prefix'] 
														? ' ' . trx_addons_prepare_macros($trx_addons_meta['doors_prefix'])
														: '')
											);
					?></span>
				</span><?php
			}
			// Passengers
			if (!empty($trx_addons_meta['passengers'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Passengers:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout($trx_addons_meta['passengers']
											 . ($trx_addons_meta['passengers_prefix'] 
														? ' ' . trx_addons_prepare_macros($trx_addons_meta['passengers_prefix'])
														: '')
											);
					?></span>
				</span><?php
			}
			// Luggage
			if (!empty($trx_addons_meta['luggage'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Luggage:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout($trx_addons_meta['luggage']
											 . ($trx_addons_meta['luggage_prefix'] 
														? ' ' . trx_addons_prepare_macros($trx_addons_meta['luggage_prefix'])
														: '')
											);
					?></span>
				</span><?php
			}
			// Mileage
			if (!empty($trx_addons_meta['mileage'])) {
				?><span class="cars_page_section_item">
					<span class="cars_page_label"><?php esc_html_e('Mileage:', 'grab-taxi'); ?></span>
					<span class="cars_page_data"><?php
						trx_addons_show_layout(trx_addons_num2kilo($trx_addons_meta['mileage'])
											. ($trx_addons_meta['mileage_prefix'] 
													? ' ' . trx_addons_prepare_macros($trx_addons_meta['mileage_prefix'])
													: '')
											);
					?></span>
				</span><?php
			}
			// Additional details
			if (!empty($trx_addons_meta['details_enable']) && !empty($trx_addons_meta['details']) && is_array($trx_addons_meta['details'])) {
				foreach ($trx_addons_meta['details'] as $detail) {
					if (!empty($detail['title'])) {
						?><span class="cars_page_section_item">
							<span class="cars_page_label"><?php
								trx_addons_show_layout(trx_addons_prepare_macros($detail['title'])); 
							?>:</span>
							<span class="cars_page_data"><?php 
								trx_addons_show_layout(trx_addons_prepare_macros($detail['value'])); 
							?></span>
						</span><?php
					}
				}
			}
		?></section><!-- .cars_page_details --><?php

		// Features
		?><section id="<?php echo esc_attr($trx_addons_tabs_id.'_features'); ?>_content" class="cars_page_section cars_page_features">
			<h4 class="cars_page_section_title"><?php echo esc_html($trx_addons_section_titles['features']); ?></h4>
			<div class="cars_page_features_list">
				<?php trx_addons_show_layout(trx_addons_get_post_terms('', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_FEATURES)); ?>
			</div>
		</section><!-- .cars_page_features --><?php


		// Attachments
		if (!empty($trx_addons_meta['attachments'])) {
			$trx_addons_meta['attachments'] = explode('|', $trx_addons_meta['attachments']);
			if (is_array($trx_addons_meta['attachments']) && count($trx_addons_meta['attachments'])>0) {
				?><section id="<?php echo esc_attr($trx_addons_tabs_id.'_attachments'); ?>_content" class="cars_page_section cars_page_attachments">
					<h4 class="cars_page_section_title"><?php echo esc_html($trx_addons_section_titles['attachments']); ?></h4><?php
					if (!empty($trx_addons_meta['attachments_description'])) {
						?><div class="cars_page_section_description"><?php
							echo wp_kses_post(nl2br($trx_addons_meta['attachments_description']));
						?></div><?php
					}
					?><div class="cars_page_attachments_list"><?php
						foreach ($trx_addons_meta['attachments'] as $file) {
							?><a href="<?php echo esc_url($file); ?>"><?php	echo esc_html(basename($file));	?></a><?php
						}
					?></div>
				</section><!-- .cars_page_attachments --><?php
			}
		}


		// Video promo
		if (!empty($trx_addons_meta['video'])) {
			?><section id="<?php echo esc_attr($trx_addons_tabs_id.'_video'); ?>_content" class="cars_page_section cars_page_video">
				<h4 class="cars_page_section_title"><?php echo esc_html($trx_addons_section_titles['video']); ?></h4><?php
					if (!empty($trx_addons_meta['video_description'])) {
						?><div class="cars_page_section_description"><?php
							echo wp_kses_post(nl2br($trx_addons_meta['video_description']));
						?></div><?php
					}
				?><div class="cars_page_video_wrap"><?php
					trx_addons_show_layout(trx_addons_get_video_layout(array(
																			'link' => $trx_addons_meta['video']
																		)));
				?></div>
			</section><!-- .cars_page_video --><?php
		}

	if ( $trx_addons_meta["agent"] !== 'none' ) {
		// Agent info
		?>
        <section id="<?php echo esc_attr( $trx_addons_tabs_id . '_contacts' ); ?>_content"
                 class="cars_page_section cars_page_agent">
        <div class="cars_page_agent_wrap"><?php
			trx_addons_get_template_part( 'cpt/cars/tpl.cars.parts.agent.php',
				'trx_addons_args_cars_agent',
				array( 'meta' => $trx_addons_meta )
			);
			?></div>
        </section><!-- .cars_page_agent --><?php
	}

		// Close tabs wrapper
		if (trx_addons_get_option('cars_single_style') == 'tabs') {
			?></div><!-- /.trx_addons_tabs cars_page_tabs --><?php
		}

	?></article><?php
	
	
	// Related items (select cars with same type and status)
	$taxonomies = array();
	$terms = get_the_terms(get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_TYPE);
	if ( !empty( $terms ) ) {
		$taxonomies[TRX_ADDONS_CPT_CARS_TAXONOMY_TYPE] = array();
		foreach( $terms as $term )
			$taxonomies[TRX_ADDONS_CPT_CARS_TAXONOMY_TYPE][] = $term->term_id;
	}
	$terms = get_the_terms(get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_STATUS);
	if ( !empty( $terms ) ) {
		$taxonomies[TRX_ADDONS_CPT_CARS_TAXONOMY_STATUS] = array();
		foreach( $terms as $term )
			$taxonomies[TRX_ADDONS_CPT_CARS_TAXONOMY_STATUS][] = $term->term_id;
	}
	
	trx_addons_get_template_part('templates/tpl.posts-related.php',
										'trx_addons_args_related',
										apply_filters('trx_addons_filter_args_related', array(
															'class' => 'cars_page_related',
															'posts_per_page' => 3,
															'columns' => 3,
															'template' => 'cpt/cars/tpl.cars.default-item.php',
															'template_args_name' => 'trx_addons_args_sc_cars',
															'post_type' => TRX_ADDONS_CPT_CARS_PT,
															'taxonomies' => $taxonomies
															)
													)
									);

	// Form
	if (shortcode_exists( 'trx_sc_form' ))
		echo do_shortcode('[trx_sc_content size="2_3" number_position="br" title_style="default"][trx_sc_form type="default" labels="" title_style="default" title_align="center" title="Send Message"][/trx_sc_content]');
	// If comments are open or we have at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) {
		comments_template();
	}
}

get_footer();
?>