<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0.22
 */

// Theme init priorities:
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
if ( !function_exists('grab_taxi_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'grab_taxi_customizer_theme_setup1', 1 );
	function grab_taxi_customizer_theme_setup1() {
		
		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		grab_taxi_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Open Sans',
				'family' => 'sans-serif',
				'styles' => '300,300i,400,400i,600,600i,700,700i,800,800i'		// Parameter 'style' used only for the Google fonts
				),
			array(
				'name'	 => 'Khula',
				'family' => 'sans-serif',
				'styles' => '300,400,600,700,800'		// Parameter 'style' used only for the Google fonts
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		grab_taxi_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		grab_taxi_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'grab-taxi'),
				'description'		=> esc_html__('Font settings of the main text of the site', 'grab-taxi'),
				'font-family'		=> 'Open Sans, sans-serif',
				'font-size' 		=> '1rem',
				'font-weight'		=> '300',
				'font-style'		=> 'normal',
				'line-height'		=> '1.73em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '0',
				'margin-bottom'		=> '1.1em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '3.823em',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.3em',
				'margin-bottom'		=> '0.39em'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '3.411em',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.45em',
				'margin-bottom'		=> '0.476em'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '2.647em',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '1.9em',
				'margin-bottom'		=> '0.75em'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '1.882em',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.218em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '2.15em',
				'margin-bottom'		=> '1.18em'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '1.294em',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.227em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '3.2em',
				'margin-bottom'		=> '1.45em'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '1.058em',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.222em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '3.15em',
				'margin-bottom'		=> '1.95em'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'grab-taxi'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '1.8em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1px'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '16px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'capitalize',
				'letter-spacing'	=> ''
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'grab-taxi'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'grab-taxi'),
				'font-family'		=> 'Open Sans, sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.22em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'grab-taxi'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'grab-taxi'),
				'font-family'		=> 'Open Sans, sans-serif',
				'font-size' 		=> '14px',
				'font-weight'		=> '300',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0.6px',
				'margin-top'		=> '0.4em',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'grab-taxi'),
				'description'		=> esc_html__('Font settings of the main menu items', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '12px',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '3.5px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'grab-taxi'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'grab-taxi'),
				'font-family'		=> 'Khula, sans-serif',
				'font-size' 		=> '12px',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1.15px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		grab_taxi_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__('Main', 'grab-taxi'),
							'description'	=> esc_html__('Colors of the main content area', 'grab-taxi')
							),
			'alter'	=> array(
							'title'			=> esc_html__('Alter', 'grab-taxi'),
							'description'	=> esc_html__('Colors of the alternative blocks (sidebars, etc.)', 'grab-taxi')
							),
			'extra'	=> array(
							'title'			=> esc_html__('Extra', 'grab-taxi'),
							'description'	=> esc_html__('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'grab-taxi')
							),
			'inverse' => array(
							'title'			=> esc_html__('Inverse', 'grab-taxi'),
							'description'	=> esc_html__('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'grab-taxi')
							),
			'input'	=> array(
							'title'			=> esc_html__('Input', 'grab-taxi'),
							'description'	=> esc_html__('Colors of the form fields (text field, textarea, select, etc.)', 'grab-taxi')
							),
			)
		);
		grab_taxi_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__('Background color', 'grab-taxi'),
							'description'	=> esc_html__('Background color of this block in the normal state', 'grab-taxi')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__('Background hover', 'grab-taxi'),
							'description'	=> esc_html__('Background color of this block in the hovered state', 'grab-taxi')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__('Border color', 'grab-taxi'),
							'description'	=> esc_html__('Border color of this block in the normal state', 'grab-taxi')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__('Border hover', 'grab-taxi'),
							'description'	=> esc_html__('Border color of this block in the hovered state', 'grab-taxi')
							),
			'text'		=> array(
							'title'			=> esc_html__('Text', 'grab-taxi'),
							'description'	=> esc_html__('Color of the plain text inside this block', 'grab-taxi')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__('Text dark', 'grab-taxi'),
							'description'	=> esc_html__('Color of the dark text (bold, header, etc.) inside this block', 'grab-taxi')
							),
			'text_light'=> array(
							'title'			=> esc_html__('Text light', 'grab-taxi'),
							'description'	=> esc_html__('Color of the light text (post meta, etc.) inside this block', 'grab-taxi')
							),
			'text_link'	=> array(
							'title'			=> esc_html__('Link', 'grab-taxi'),
							'description'	=> esc_html__('Color of the links inside this block', 'grab-taxi')
							),
			'text_hover'=> array(
							'title'			=> esc_html__('Link hover', 'grab-taxi'),
							'description'	=> esc_html__('Color of the hovered state of links inside this block', 'grab-taxi')
							),
			'text_link2'=> array(
							'title'			=> esc_html__('Link 2', 'grab-taxi'),
							'description'	=> esc_html__('Color of the accented texts (areas) inside this block', 'grab-taxi')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__('Link 2 hover', 'grab-taxi'),
							'description'	=> esc_html__('Color of the hovered state of accented texts (areas) inside this block', 'grab-taxi')
							),
			'text_link3'=> array(
							'title'			=> esc_html__('Link 3', 'grab-taxi'),
							'description'	=> esc_html__('Color of the other accented texts (buttons) inside this block', 'grab-taxi')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__('Link 3 hover', 'grab-taxi'),
							'description'	=> esc_html__('Color of the hovered state of other accented texts (buttons) inside this block', 'grab-taxi')
							)
			)
		);
		grab_taxi_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'grab-taxi'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff', // !
					'bd_color'			=> '#e5e5e5', // !
		
					// Text and links colors
					'text'				=> '#44464b', // !
					'text_light'		=> '#959699', // !
					'text_dark'			=> '#171717', // !
					'text_link'			=> '#959699', // !
					'text_hover'		=> '#fecc18', // !
					'text_link2'		=> '#80d572',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#f5f5f5', // !
					'alter_bg_hover'	=> '#e6e8eb', // !
					'alter_bd_color'	=> '#ececec', // !
					'alter_bd_hover'	=> '#fafafa', // !
					'alter_text'		=> '#44464b', // !
					'alter_light'		=> '#959699', // !
					'alter_dark'		=> '#1d1d1d', // !
					'alter_link'		=> '#cdcdcd', // !
					'alter_hover'		=> '#fecc18', // !
					'alter_link2'		=> '#959699',
					'alter_hover2'		=> '#171717', // !
					'alter_link3'		=> '#ddb837',
					'alter_hover3'		=> '#eec432',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#fecc18', // !
					'extra_bg_hover'	=> '#fed243', // !
					'extra_bd_color'	=> '#313131',
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#ffffff', // !
					'extra_light'		=> '#afafaf',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#171717', // !
					'extra_hover'		=> '#171717', // !
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#ffffff', // !
					'input_bg_hover'	=> '#ffffff', // !
					'input_bd_color'	=> '#ececec', // !
					'input_bd_hover'	=> '#171717', // !
					'input_text'		=> '#44464b', // !
					'input_light'		=> '#d0d0d0',
					'input_dark'		=> '#171717', // !
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#1d1d1d', // !
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff', // !
					'inverse_hover'		=> '#1d1d1d'
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'grab-taxi'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#000000', // !
					'bd_color'			=> '#2d2d2d', // !
		
					// Text and links colors
					'text'				=> '#a3a4a6', // !
					'text_light'		=> '#68696f', // !
					'text_dark'			=> '#ffffff', // !
					'text_link'			=> '#68696f', // !
					'text_hover'		=> '#fecc18', // !
					'text_link2'		=> '#80d572',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#222222', // !
					'alter_bg_hover'	=> '#373737', // !
					'alter_bd_color'	=> '#313131', // !
					'alter_bd_hover'	=> '#3d3d3d', // !
					'alter_text'		=> '#a3a4a6', // !
					'alter_light'		=> '#68696f', // !
					'alter_dark'		=> '#ffffff', // !
					'alter_link'		=> '#68696f', // !
					'alter_hover'		=> '#fecc18', // !
					'alter_link2'		=> '#959699', // !
					'alter_hover2'		=> '#ffffff', // !
					'alter_link3'		=> '#ddb837',
					'alter_hover3'		=> '#eec432',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#fecc18', // !
					'extra_bg_hover'	=> '#fed243', // !
					'extra_bd_color'	=> '#313131',
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#ffffff', // !
					'extra_light'		=> '#5f5f5f',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#171717', // !
					'extra_hover'		=> '#171717', // !
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#171717', // !
					'input_bg_hover'	=> '#171717', // !
					'input_bd_color'	=> '#2d2d2d', // !
					'input_bd_hover'	=> '#ffffff', // !
					'input_text'		=> '#a3a4a6', // !
					'input_light'		=> '#5f5f5f',
					'input_dark'		=> '#ffffff', // !
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#1d1d1d', // !
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff', // !
					'inverse_hover'		=> '#1d1d1d'
				)
			)
		
		));
	}
}

			
// Additional (calculated) theme-specific colors
// Attention! Don't forget setup custom colors also in the theme.customizer.color-scheme.js
if (!function_exists('grab_taxi_customizer_add_theme_colors')) {
	function grab_taxi_customizer_add_theme_colors($colors) {
		if (substr($colors['text'], 0, 1) == '#') {
			$colors['bg_color_0']  = grab_taxi_hex2rgba( $colors['bg_color'], 0 );
			$colors['bg_color_02']  = grab_taxi_hex2rgba( $colors['bg_color'], 0.2 );
			$colors['bg_color_07']  = grab_taxi_hex2rgba( $colors['bg_color'], 0.7 );
			$colors['bg_color_08']  = grab_taxi_hex2rgba( $colors['bg_color'], 0.8 );
			$colors['bg_color_09']  = grab_taxi_hex2rgba( $colors['bg_color'], 0.9 );
			$colors['alter_bg_color_07']  = grab_taxi_hex2rgba( $colors['alter_bg_color'], 0.7 );
			$colors['alter_bg_color_04']  = grab_taxi_hex2rgba( $colors['alter_bg_color'], 0.4 );
			$colors['alter_bg_color_02']  = grab_taxi_hex2rgba( $colors['alter_bg_color'], 0.2 );
			$colors['alter_bd_color_02']  = grab_taxi_hex2rgba( $colors['alter_bd_color'], 0.2 );
			$colors['extra_bg_color_02']  = grab_taxi_hex2rgba( $colors['extra_bg_color'], 0.2 );
			$colors['extra_bg_color_07']  = grab_taxi_hex2rgba( $colors['extra_bg_color'], 0.7 );
			$colors['text_dark_01']  = grab_taxi_hex2rgba( $colors['text_dark'], 0.1 );
			$colors['text_dark_02']  = grab_taxi_hex2rgba( $colors['text_dark'], 0.2 );
			$colors['text_dark_07']  = grab_taxi_hex2rgba( $colors['text_dark'], 0.7 );
			$colors['text_link_02']  = grab_taxi_hex2rgba( $colors['text_link'], 0.2 );
			$colors['text_link_07']  = grab_taxi_hex2rgba( $colors['text_link'], 0.7 );
			$colors['text_link_blend'] = grab_taxi_hsb2hex(grab_taxi_hex2hsb( $colors['text_link'], 2, -5, 5 ));
			$colors['alter_link_blend'] = grab_taxi_hsb2hex(grab_taxi_hex2hsb( $colors['alter_link'], 2, -5, 5 ));
		} else {
			$colors['bg_color_0'] = '{{ data.bg_color_0 }}';
			$colors['bg_color_02'] = '{{ data.bg_color_02 }}';
			$colors['bg_color_07'] = '{{ data.bg_color_07 }}';
			$colors['bg_color_08'] = '{{ data.bg_color_08 }}';
			$colors['bg_color_09'] = '{{ data.bg_color_09 }}';
			$colors['alter_bg_color_07'] = '{{ data.alter_bg_color_07 }}';
			$colors['alter_bg_color_04'] = '{{ data.alter_bg_color_04 }}';
			$colors['alter_bg_color_02'] = '{{ data.alter_bg_color_02 }}';
			$colors['alter_bd_color_02'] = '{{ data.alter_bd_color_02 }}';
			$colors['extra_bg_color_02'] = '{{ data.extra_bg_color_02 }}';
			$colors['extra_bg_color_07'] = '{{ data.extra_bg_color_07 }}';
			$colors['text_dark_01'] = '{{ data.text_dark_01 }}';
			$colors['text_dark_02'] = '{{ data.text_dark_02 }}';
			$colors['text_dark_07'] = '{{ data.text_dark_07 }}';
			$colors['text_link_02'] = '{{ data.text_link_02 }}';
			$colors['text_link_07'] = '{{ data.text_link_07 }}';
			$colors['text_link_blend'] = '{{ data.text_link_blend }}';
			$colors['alter_link_blend'] = '{{ data.alter_link_blend }}';
		}
		return $colors;
	}
}


			
// Additional theme-specific fonts rules
// Attention! Don't forget setup fonts rules also in the theme.customizer.color-scheme.js
if (!function_exists('grab_taxi_customizer_add_theme_fonts')) {
	function grab_taxi_customizer_add_theme_fonts($fonts) {
		$rez = array();	
		foreach ($fonts as $tag => $font) {
			if (substr($font['font-family'], 0, 2) != '{{') {
				$rez[$tag.'_font-family'] 		= !empty($font['font-family']) && !grab_taxi_is_inherit($font['font-family'])
														? 'font-family:' . trim($font['font-family']) . ';' 
														: '';
				$rez[$tag.'_font-size'] 		= !empty($font['font-size']) && !grab_taxi_is_inherit($font['font-size'])
														? 'font-size:' . grab_taxi_prepare_css_value($font['font-size']) . ";"
														: '';
				$rez[$tag.'_line-height'] 		= !empty($font['line-height']) && !grab_taxi_is_inherit($font['line-height'])
														? 'line-height:' . trim($font['line-height']) . ";"
														: '';
				$rez[$tag.'_font-weight'] 		= !empty($font['font-weight']) && !grab_taxi_is_inherit($font['font-weight'])
														? 'font-weight:' . trim($font['font-weight']) . ";"
														: '';
				$rez[$tag.'_font-style'] 		= !empty($font['font-style']) && !grab_taxi_is_inherit($font['font-style'])
														? 'font-style:' . trim($font['font-style']) . ";"
														: '';
				$rez[$tag.'_text-decoration'] 	= !empty($font['text-decoration']) && !grab_taxi_is_inherit($font['text-decoration'])
														? 'text-decoration:' . trim($font['text-decoration']) . ";"
														: '';
				$rez[$tag.'_text-transform'] 	= !empty($font['text-transform']) && !grab_taxi_is_inherit($font['text-transform'])
														? 'text-transform:' . trim($font['text-transform']) . ";"
														: '';
				$rez[$tag.'_letter-spacing'] 	= !empty($font['letter-spacing']) && !grab_taxi_is_inherit($font['letter-spacing'])
														? 'letter-spacing:' . trim($font['letter-spacing']) . ";"
														: '';
				$rez[$tag.'_margin-top'] 		= !empty($font['margin-top']) && !grab_taxi_is_inherit($font['margin-top'])
														? 'margin-top:' . grab_taxi_prepare_css_value($font['margin-top']) . ";"
														: '';
				$rez[$tag.'_margin-bottom'] 	= !empty($font['margin-bottom']) && !grab_taxi_is_inherit($font['margin-bottom'])
														? 'margin-bottom:' . grab_taxi_prepare_css_value($font['margin-bottom']) . ";"
														: '';
			} else {
				$rez[$tag.'_font-family']		= '{{ data["'.$tag.'_font-family"] }}';
				$rez[$tag.'_font-size']			= '{{ data["'.$tag.'_font-size"] }}';
				$rez[$tag.'_line-height']		= '{{ data["'.$tag.'_line-height"] }}';
				$rez[$tag.'_font-weight']		= '{{ data["'.$tag.'_font-weight"] }}';
				$rez[$tag.'_font-style']		= '{{ data["'.$tag.'_font-style"] }}';
				$rez[$tag.'_text-decoration']	= '{{ data["'.$tag.'_text-decoration"] }}';
				$rez[$tag.'_text-transform']	= '{{ data["'.$tag.'_text-transform"] }}';
				$rez[$tag.'_letter-spacing']	= '{{ data["'.$tag.'_letter-spacing"] }}';
				$rez[$tag.'_margin-top']		= '{{ data["'.$tag.'_margin-top"] }}';
				$rez[$tag.'_margin-bottom']		= '{{ data["'.$tag.'_margin-bottom"] }}';
			}
		}
		return $rez;
	}
}


//-------------------------------------------------------
//-- Thumb sizes
//-------------------------------------------------------

if ( !function_exists('grab_taxi_customizer_theme_setup') ) {
	add_action( 'after_setup_theme', 'grab_taxi_customizer_theme_setup' );
	function grab_taxi_customizer_theme_setup() {

		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size(370, 0, false);
		
		// Add thumb sizes
		// ATTENTION! If you change list below - check filter's names in the 'trx_addons_filter_get_thumb_size' hook
		$thumb_sizes = apply_filters('grab_taxi_filter_add_thumb_sizes', array(
			'grab_taxi-thumb-huge'		=> array(1170, 658, true),
			'grab_taxi-thumb-big' 		=> array( 760, 428, true),
			'grab_taxi-thumb-med' 		=> array( 370, 208, true),
			'grab_taxi-thumb-tiny' 		=> array(  90,  90, true),
			'grab_taxi-thumb-masonry-big' => array( 760,   0, false),		// Only downscale, not crop
			'grab_taxi-thumb-iconed' 		=> array(  31,  32, true),
			'grab_taxi-thumb-masonry'		=> array( 370,   0, false),		// Only downscale, not crop
			)
		);
		$mult = grab_taxi_get_theme_option('retina_ready', 1);
		if ($mult > 1) $GLOBALS['content_width'] = apply_filters( 'grab_taxi_filter_content_width', 1170*$mult);
		foreach ($thumb_sizes as $k=>$v) {
			// Add Original dimensions
			add_image_size( $k, $v[0], $v[1], $v[2]);
			// Add Retina dimensions
			if ($mult > 1) add_image_size( $k.'-@retina', $v[0]*$mult, $v[1]*$mult, $v[2]);
		}

	}
}

if ( !function_exists('grab_taxi_customizer_image_sizes') ) {
	add_filter( 'image_size_names_choose', 'grab_taxi_customizer_image_sizes' );
	function grab_taxi_customizer_image_sizes( $sizes ) {
		$thumb_sizes = apply_filters('grab_taxi_filter_add_thumb_sizes', array(
			'grab_taxi-thumb-huge'		=> esc_html__( 'Fullsize image', 'grab-taxi' ),
			'grab_taxi-thumb-big'			=> esc_html__( 'Large image', 'grab-taxi' ),
			'grab_taxi-thumb-med'			=> esc_html__( 'Medium image', 'grab-taxi' ),
			'grab_taxi-thumb-tiny'		=> esc_html__( 'Small square avatar', 'grab-taxi' ),
			'grab_taxi-thumb-iconed'		=> esc_html__( 'Image-icon square avatar', 'grab-taxi' ),
			'grab_taxi-thumb-masonry-big'	=> esc_html__( 'Masonry Large (scaled)', 'grab-taxi' ),
			'grab_taxi-thumb-masonry'		=> esc_html__( 'Masonry (scaled)', 'grab-taxi' ),
			)
		);
		$mult = grab_taxi_get_theme_option('retina_ready', 1);
		foreach($thumb_sizes as $k=>$v) {
			$sizes[$k] = $v;
			if ($mult > 1) $sizes[$k.'-@retina'] = $v.' '.esc_html__('@2x', 'grab-taxi' );
		}
		return $sizes;
	}
}

// Remove some thumb-sizes from the ThemeREX Addons list
if ( !function_exists( 'grab_taxi_customizer_trx_addons_add_thumb_sizes' ) ) {
	add_filter( 'trx_addons_filter_add_thumb_sizes', 'grab_taxi_customizer_trx_addons_add_thumb_sizes');
	function grab_taxi_customizer_trx_addons_add_thumb_sizes($list=array()) {
		if (is_array($list)) {
			foreach ($list as $k=>$v) {
				if (in_array($k, array(
								'trx_addons-thumb-huge',
								'trx_addons-thumb-big',
								'trx_addons-thumb-medium',
								'trx_addons-thumb-tiny',
								'trx_addons-thumb-masonry-big',
								'trx_addons-thumb-iconed',
								'trx_addons-thumb-masonry',
								)
							)
						) unset($list[$k]);
			}
		}
		return $list;
	}
}

// and replace removed styles with theme-specific thumb size
if ( !function_exists( 'grab_taxi_customizer_trx_addons_get_thumb_size' ) ) {
	add_filter( 'trx_addons_filter_get_thumb_size', 'grab_taxi_customizer_trx_addons_get_thumb_size');
	function grab_taxi_customizer_trx_addons_get_thumb_size($thumb_size='') {
		return str_replace(array(
							'trx_addons-thumb-huge',
							'trx_addons-thumb-huge-@retina',
							'trx_addons-thumb-big',
							'trx_addons-thumb-big-@retina',
							'trx_addons-thumb-medium',
							'trx_addons-thumb-medium-@retina',
							'trx_addons-thumb-tiny',
							'trx_addons-thumb-tiny-@retina',
							'trx_addons-thumb-masonry-big',
							'trx_addons-thumb-masonry-big-@retina',
							'trx_addons-thumb-iconed',
							'trx_addons-thumb-iconed-@retina',
							'trx_addons-thumb-masonry',
							'trx_addons-thumb-masonry-@retina',
							),
							array(
							'grab_taxi-thumb-huge',
							'grab_taxi-thumb-huge-@retina',
							'grab_taxi-thumb-big',
							'grab_taxi-thumb-big-@retina',
							'grab_taxi-thumb-med',
							'grab_taxi-thumb-med-@retina',
							'grab_taxi-thumb-tiny',
							'grab_taxi-thumb-tiny-@retina',
							'grab_taxi-thumb-masonry-big',
							'grab_taxi-thumb-masonry-big-@retina',
							'grab_taxi-thumb-iconed',
							'grab_taxi-thumb-iconed-@retina',
							'grab_taxi-thumb-masonry',
							'grab_taxi-thumb-masonry-@retina',
							),
							$thumb_size);
	}
}
?>