<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

// Header sidebar
$grab_taxi_header_name = grab_taxi_get_theme_option('header_widgets');
$grab_taxi_header_present = !grab_taxi_is_off($grab_taxi_header_name) && is_active_sidebar($grab_taxi_header_name);
if ($grab_taxi_header_present) { 
	grab_taxi_storage_set('current_sidebar', 'header');
	$grab_taxi_header_wide = grab_taxi_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($grab_taxi_header_name) ) {
		dynamic_sidebar($grab_taxi_header_name);
	}
	$grab_taxi_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($grab_taxi_widgets_output)) {
		$grab_taxi_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $grab_taxi_widgets_output);
		$grab_taxi_need_columns = strpos($grab_taxi_widgets_output, 'columns_wrap')===false;
		if ($grab_taxi_need_columns) {
			$grab_taxi_columns = max(0, (int) grab_taxi_get_theme_option('header_columns'));
			if ($grab_taxi_columns == 0) $grab_taxi_columns = min(6, max(1, substr_count($grab_taxi_widgets_output, '<aside ')));
			if ($grab_taxi_columns > 1)
				$grab_taxi_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($grab_taxi_columns).' widget ', $grab_taxi_widgets_output);
			else
				$grab_taxi_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($grab_taxi_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$grab_taxi_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($grab_taxi_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'grab_taxi_action_before_sidebar' );
				grab_taxi_show_layout($grab_taxi_widgets_output);
				do_action( 'grab_taxi_action_after_sidebar' );
				if ($grab_taxi_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$grab_taxi_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>