<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0.14
 */
$grab_taxi_header_video = grab_taxi_get_header_video();
$grab_taxi_embed_video = '';
if (!empty($grab_taxi_header_video) && !grab_taxi_is_from_uploads($grab_taxi_header_video)) {
	if (grab_taxi_is_youtube_url($grab_taxi_header_video) && preg_match('/[=\/]([^=\/]*)$/', $grab_taxi_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$grab_taxi_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($grab_taxi_header_video) . '[/embed]' ));
			$grab_taxi_embed_video = grab_taxi_make_video_autoplay($grab_taxi_embed_video);
		} else {
			$grab_taxi_header_video = str_replace('/watch?v=', '/embed/', $grab_taxi_header_video);
			$grab_taxi_header_video = grab_taxi_add_to_url($grab_taxi_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url(),
				'widgetid' => 1
			));
			$grab_taxi_embed_video = '<iframe src="' . esc_url($grab_taxi_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php grab_taxi_show_layout($grab_taxi_embed_video); ?></div><?php
	}
}
?>