<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0.06
 */

$grab_taxi_header_css = $grab_taxi_header_image = '';
$grab_taxi_header_video = grab_taxi_get_header_video();
if (true || empty($grab_taxi_header_video)) {
	$grab_taxi_header_image = get_header_image();
	if (grab_taxi_is_on(grab_taxi_get_theme_option('header_image_override')) && apply_filters('grab_taxi_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($grab_taxi_cat_img = grab_taxi_get_category_image()) != '')
				$grab_taxi_header_image = $grab_taxi_cat_img;
		} else if (is_singular() || grab_taxi_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$grab_taxi_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($grab_taxi_header_image)) $grab_taxi_header_image = $grab_taxi_header_image[0];
			} else
				$grab_taxi_header_image = '';
		}
	}
}

$grab_taxi_header_id = str_replace('header-custom-', '', grab_taxi_get_theme_option("header_style"));
$grab_taxi_header_meta = get_post_meta($grab_taxi_header_id, 'trx_addons_options', true);

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($grab_taxi_header_id); 
						?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($grab_taxi_header_id)));
						echo !empty($grab_taxi_header_image) || !empty($grab_taxi_header_video) 
							? ' with_bg_image' 
							: ' without_bg_image';
						if ($grab_taxi_header_video!='') 
							echo ' with_bg_video';
						if ($grab_taxi_header_image!='') 
							echo ' '.esc_attr(grab_taxi_add_inline_css_class('background-image: url('.esc_url($grab_taxi_header_image).');'));
						if (!empty($grab_taxi_header_meta['margin']) != '') 
							echo ' '.esc_attr(grab_taxi_add_inline_css_class('margin-bottom: '.esc_attr(grab_taxi_prepare_css_value($grab_taxi_header_meta['margin'])).';'));
						if (is_single() && has_post_thumbnail()) 
							echo ' with_featured_image';
						if (grab_taxi_is_on(grab_taxi_get_theme_option('header_fullheight'))) 
							echo ' header_fullheight trx-stretch-height';
						?> scheme_<?php echo esc_attr(grab_taxi_is_inherit(grab_taxi_get_theme_option('header_scheme')) 
														? grab_taxi_get_theme_option('color_scheme') 
														: grab_taxi_get_theme_option('header_scheme'));
						?>"><?php

	// Background video
	if (!empty($grab_taxi_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('grab_taxi_action_show_layout', $grab_taxi_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>