<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0.10
 */

$grab_taxi_footer_scheme =  grab_taxi_is_inherit(grab_taxi_get_theme_option('footer_scheme')) ? grab_taxi_get_theme_option('color_scheme') : grab_taxi_get_theme_option('footer_scheme');
$grab_taxi_footer_id = str_replace('footer-custom-', '', grab_taxi_get_theme_option("footer_style"));
$grab_taxi_footer_meta = get_post_meta($grab_taxi_footer_id, 'trx_addons_options', true);
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($grab_taxi_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($grab_taxi_footer_id))); 
						if (!empty($grab_taxi_footer_meta['margin']) != '') 
							echo ' '.esc_attr(grab_taxi_add_inline_css_class('margin-top: '.esc_attr(grab_taxi_prepare_css_value($grab_taxi_footer_meta['margin'])).';'));
						?> scheme_<?php echo esc_attr($grab_taxi_footer_scheme); 
						?>">
	<?php
    // Custom footer's layout
    do_action('grab_taxi_action_show_layout', $grab_taxi_footer_id);
	?>
</footer><!-- /.footer_wrap -->
