<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */
?>

<div class="author_info scheme_dark author vcard" itemprop="author" itemscope itemtype="http://schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php 
		$grab_taxi_mult = grab_taxi_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120*$grab_taxi_mult ); 
		?>
	</div><!-- .author_avatar -->

	<div class="author_description">
		<h5 class="author_title" itemprop="name"><?php echo wp_kses_data(sprintf(__('About %s', 'grab-taxi'), '<span class="fn">'.get_the_author().'</span>')); ?></h5>

		<div class="author_bio" itemprop="description">
			<?php echo wp_kses_post(wpautop(get_the_author_meta( 'description' ))); ?>
			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="sc_button color_style_dark sc_button_default sc_button_size_normal sc_button_icon_right author_link"  rel="author"><span class="sc_button_text">
					<span class="sc_button_title"><?php echo esc_html__( 'Learn more', 'grab-taxi' ) ?></span></span><!-- /.sc_button_text -->
			</a>
			<?php do_action('grab_taxi_action_user_meta'); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

</div><!-- .author_info -->
