<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0.1
 */
?>
<div class="update-nag" id="grab_taxi_admin_notice">
	<h3 class="grab_taxi_notice_title"><?php echo sprintf(esc_html__('Welcome to %s', 'grab-taxi'), wp_get_theme()->name); ?></h3>
	<?php
	if (!grab_taxi_exists_trx_addons()) {
		?><p><?php echo wp_kses_data(__('<b>Attention!</b> Plugin "ThemeREX Addons is required! Please, install and activate it!', 'grab-taxi')); ?></p><?php
	}
	?><p><?php
		if (grab_taxi_get_value_gp('page')!='tgmpa-install-plugins') {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=tgmpa-install-plugins'); ?>" class="button-primary"><i class="dashicons dashicons-admin-plugins"></i> <?php esc_html_e('Install plugins', 'grab-taxi'); ?></a>
			<?php
		}
		if (function_exists('grab_taxi_exists_trx_addons') && grab_taxi_exists_trx_addons()) {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=trx_importer'); ?>" class="button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e('One Click Demo Data', 'grab-taxi'); ?></a>
			<?php
		}
		?>
        <a href="<?php echo esc_url(admin_url().'customize.php'); ?>" class="button-primary"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Customizer', 'grab-taxi'); ?></a>
        <a href="#" class="button grab_taxi_hide_notice"><i class="dashicons dashicons-dismiss"></i> <?php esc_html_e('Hide Notice', 'grab-taxi'); ?></a>
	</p>
</div>