<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

$grab_taxi_columns = max(1, min(3, count(get_option( 'sticky_posts' ))));
$grab_taxi_post_format = get_post_format();
$grab_taxi_post_format = empty($grab_taxi_post_format) ? 'standard' : str_replace('post-format-', '', $grab_taxi_post_format);
$grab_taxi_animation = grab_taxi_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($grab_taxi_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_sticky post_format_'.esc_attr($grab_taxi_post_format) ); ?>
	<?php echo (!grab_taxi_is_off($grab_taxi_animation) ? ' data-animation="'.esc_attr(grab_taxi_get_animation_classes($grab_taxi_animation)).'"' : ''); ?>
	>

	<?php
	if ( is_sticky() && is_home() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	grab_taxi_show_post_featured(array(
		'thumb_size' => grab_taxi_get_thumb_size($grab_taxi_columns==1 ? 'big' : ($grab_taxi_columns==2 ? 'med' : 'avatar'))
	));

	if ( !in_array($grab_taxi_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h6 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(), 'sticky', $grab_taxi_columns));
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div>