<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the Visual Composer to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$grab_taxi_content = '';
$grab_taxi_blog_archive_mask = '%%CONTENT%%';
$grab_taxi_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $grab_taxi_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($grab_taxi_content = apply_filters('the_content', get_the_content())) != '') {
		if (($grab_taxi_pos = strpos($grab_taxi_content, $grab_taxi_blog_archive_mask)) !== false) {
			$grab_taxi_content = preg_replace('/(\<p\>\s*)?'.$grab_taxi_blog_archive_mask.'(\s*\<\/p\>)/i', $grab_taxi_blog_archive_subst, $grab_taxi_content);
		} else
			$grab_taxi_content .= $grab_taxi_blog_archive_subst;
		$grab_taxi_content = explode($grab_taxi_blog_archive_mask, $grab_taxi_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) grab_taxi_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$grab_taxi_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$grab_taxi_args = grab_taxi_query_add_posts_and_cats($grab_taxi_args, '', grab_taxi_get_theme_option('post_type'), grab_taxi_get_theme_option('parent_cat'));
$grab_taxi_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($grab_taxi_page_number > 1) {
	$grab_taxi_args['paged'] = $grab_taxi_page_number;
	$grab_taxi_args['ignore_sticky_posts'] = true;
}
$grab_taxi_ppp = grab_taxi_get_theme_option('posts_per_page');
if ((int) $grab_taxi_ppp != 0)
	$grab_taxi_args['posts_per_page'] = (int) $grab_taxi_ppp;
// Make a new query
query_posts( $grab_taxi_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($grab_taxi_content) && count($grab_taxi_content) == 2) {
	set_query_var('blog_archive_start', $grab_taxi_content[0]);
	set_query_var('blog_archive_end', $grab_taxi_content[1]);
}

get_template_part('index');
?>