<?php

declare (strict_types=1);
namespace WPForms\Vendor\Square\Models;

use stdClass;
/**
 * An image file to use in Square catalogs. It can be associated with
 * `CatalogItem`, `CatalogItemVariation`, `CatalogCategory`, and `CatalogModifierList` objects.
 * Only the images on items and item variations are exposed in Dashboard.
 * Only the first image on an item is displayed in Square Point of Sale (SPOS).
 * Images on items and variations are displayed through Square Online Store.
 * Images on other object types are for use by 3rd party application developers.
 */
class CatalogImage implements \JsonSerializable
{
    /**
     * @var array
     */
    private $name = [];
    /**
     * @var array
     */
    private $url = [];
    /**
     * @var array
     */
    private $caption = [];
    /**
     * @var array
     */
    private $photoStudioOrderId = [];
    /**
     * Returns Name.
     * The internal name to identify this image in calls to the Square API.
     * This is a searchable attribute for use in applicable query filters
     * using the [SearchCatalogObjects](api-endpoint:Catalog-SearchCatalogObjects).
     * It is not unique and should not be shown in a buyer facing context.
     */
    public function getName() : ?string
    {
        if (\count($this->name) == 0) {
            return null;
        }
        return $this->name['value'];
    }
    /**
     * Sets Name.
     * The internal name to identify this image in calls to the Square API.
     * This is a searchable attribute for use in applicable query filters
     * using the [SearchCatalogObjects](api-endpoint:Catalog-SearchCatalogObjects).
     * It is not unique and should not be shown in a buyer facing context.
     *
     * @maps name
     */
    public function setName(?string $name) : void
    {
        $this->name['value'] = $name;
    }
    /**
     * Unsets Name.
     * The internal name to identify this image in calls to the Square API.
     * This is a searchable attribute for use in applicable query filters
     * using the [SearchCatalogObjects](api-endpoint:Catalog-SearchCatalogObjects).
     * It is not unique and should not be shown in a buyer facing context.
     */
    public function unsetName() : void
    {
        $this->name = [];
    }
    /**
     * Returns Url.
     * The URL of this image, generated by Square after an image is uploaded
     * using the [CreateCatalogImage](api-endpoint:Catalog-CreateCatalogImage) endpoint.
     * To modify the image, use the UpdateCatalogImage endpoint. Do not change the URL field.
     */
    public function getUrl() : ?string
    {
        if (\count($this->url) == 0) {
            return null;
        }
        return $this->url['value'];
    }
    /**
     * Sets Url.
     * The URL of this image, generated by Square after an image is uploaded
     * using the [CreateCatalogImage](api-endpoint:Catalog-CreateCatalogImage) endpoint.
     * To modify the image, use the UpdateCatalogImage endpoint. Do not change the URL field.
     *
     * @maps url
     */
    public function setUrl(?string $url) : void
    {
        $this->url['value'] = $url;
    }
    /**
     * Unsets Url.
     * The URL of this image, generated by Square after an image is uploaded
     * using the [CreateCatalogImage](api-endpoint:Catalog-CreateCatalogImage) endpoint.
     * To modify the image, use the UpdateCatalogImage endpoint. Do not change the URL field.
     */
    public function unsetUrl() : void
    {
        $this->url = [];
    }
    /**
     * Returns Caption.
     * A caption that describes what is shown in the image. Displayed in the
     * Square Online Store. This is a searchable attribute for use in applicable query filters
     * using the [SearchCatalogObjects](api-endpoint:Catalog-SearchCatalogObjects).
     */
    public function getCaption() : ?string
    {
        if (\count($this->caption) == 0) {
            return null;
        }
        return $this->caption['value'];
    }
    /**
     * Sets Caption.
     * A caption that describes what is shown in the image. Displayed in the
     * Square Online Store. This is a searchable attribute for use in applicable query filters
     * using the [SearchCatalogObjects](api-endpoint:Catalog-SearchCatalogObjects).
     *
     * @maps caption
     */
    public function setCaption(?string $caption) : void
    {
        $this->caption['value'] = $caption;
    }
    /**
     * Unsets Caption.
     * A caption that describes what is shown in the image. Displayed in the
     * Square Online Store. This is a searchable attribute for use in applicable query filters
     * using the [SearchCatalogObjects](api-endpoint:Catalog-SearchCatalogObjects).
     */
    public function unsetCaption() : void
    {
        $this->caption = [];
    }
    /**
     * Returns Photo Studio Order Id.
     * The immutable order ID for this image object created by the Photo Studio service in Square Online
     * Store.
     */
    public function getPhotoStudioOrderId() : ?string
    {
        if (\count($this->photoStudioOrderId) == 0) {
            return null;
        }
        return $this->photoStudioOrderId['value'];
    }
    /**
     * Sets Photo Studio Order Id.
     * The immutable order ID for this image object created by the Photo Studio service in Square Online
     * Store.
     *
     * @maps photo_studio_order_id
     */
    public function setPhotoStudioOrderId(?string $photoStudioOrderId) : void
    {
        $this->photoStudioOrderId['value'] = $photoStudioOrderId;
    }
    /**
     * Unsets Photo Studio Order Id.
     * The immutable order ID for this image object created by the Photo Studio service in Square Online
     * Store.
     */
    public function unsetPhotoStudioOrderId() : void
    {
        $this->photoStudioOrderId = [];
    }
    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize(bool $asArrayWhenEmpty = \false)
    {
        $json = [];
        if (!empty($this->name)) {
            $json['name'] = $this->name['value'];
        }
        if (!empty($this->url)) {
            $json['url'] = $this->url['value'];
        }
        if (!empty($this->caption)) {
            $json['caption'] = $this->caption['value'];
        }
        if (!empty($this->photoStudioOrderId)) {
            $json['photo_studio_order_id'] = $this->photoStudioOrderId['value'];
        }
        $json = \array_filter($json, function ($val) {
            return $val !== null;
        });
        return !$asArrayWhenEmpty && empty($json) ? new stdClass() : $json;
    }
}
