<?php
/**
 * The template to show mobile menu
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr(grab_taxi_get_theme_option('menu_mobile_fullscreen') > 0 ? 'fullscreen' : 'narrow'); ?> scheme_dark">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close icon-cancel"></a><?php

		// Logo
		set_query_var('grab_taxi_logo_args', array('type' => 'inverse'));
		get_template_part( 'templates/header-logo' );
		set_query_var('grab_taxi_logo_args', array());

		// Mobile menu
		$grab_taxi_menu_mobile = grab_taxi_get_nav_menu('menu_mobile');
		if (empty($grab_taxi_menu_mobile)) {
			$grab_taxi_menu_mobile = apply_filters('grab_taxi_filter_get_mobile_menu', '');
			if (empty($grab_taxi_menu_mobile)) $grab_taxi_menu_mobile = grab_taxi_get_nav_menu('menu_main');
			if (empty($grab_taxi_menu_mobile)) $grab_taxi_menu_mobile = grab_taxi_get_nav_menu();
		}
		if (!empty($grab_taxi_menu_mobile)) {
			if (!empty($grab_taxi_menu_mobile))
				$grab_taxi_menu_mobile = str_replace(
					array('menu_main', 'id="menu-', 'sc_layouts_menu_nav', 'sc_layouts_hide_on_mobile', 'hide_on_mobile'),
					array('menu_mobile', 'id="menu_mobile-', '', '', ''),
					$grab_taxi_menu_mobile
					);
			if (strpos($grab_taxi_menu_mobile, '<nav ')===false)
				$grab_taxi_menu_mobile = sprintf('<nav class="menu_mobile_nav_area">%s</nav>', $grab_taxi_menu_mobile);
			grab_taxi_show_layout(apply_filters('grab_taxi_filter_menu_mobile_layout', $grab_taxi_menu_mobile));
		}

		// Search field
		do_action('grab_taxi_action_search', 'normal', 'search_mobile', false);
		
		// Social icons
		grab_taxi_show_layout(grab_taxi_get_socials_links(), '<div class="socials_mobile">', '</div>');
		?>
	</div>
</div>
