<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0.10
 */

// Footer sidebar
$grab_taxi_footer_name = grab_taxi_get_theme_option('footer_widgets');
$grab_taxi_footer_present = !grab_taxi_is_off($grab_taxi_footer_name) && is_active_sidebar($grab_taxi_footer_name);
if ($grab_taxi_footer_present) { 
	grab_taxi_storage_set('current_sidebar', 'footer');
	$grab_taxi_footer_wide = grab_taxi_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($grab_taxi_footer_name) ) {
		dynamic_sidebar($grab_taxi_footer_name);
	}
	$grab_taxi_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($grab_taxi_out)) {
		$grab_taxi_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $grab_taxi_out);
		$grab_taxi_need_columns = true;
		if ($grab_taxi_need_columns) {
			$grab_taxi_columns = max(0, (int) grab_taxi_get_theme_option('footer_columns'));
			if ($grab_taxi_columns == 0) $grab_taxi_columns = min(4, max(1, substr_count($grab_taxi_out, '<aside ')));
			if ($grab_taxi_columns > 1)
				$grab_taxi_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($grab_taxi_columns).' widget ', $grab_taxi_out);
			else
				$grab_taxi_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($grab_taxi_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row  sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$grab_taxi_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($grab_taxi_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'grab_taxi_action_before_sidebar' );
				grab_taxi_show_layout($grab_taxi_out);
				do_action( 'grab_taxi_action_after_sidebar' );
				if ($grab_taxi_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$grab_taxi_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>