<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('grab_taxi_storage_get')) {
	function grab_taxi_storage_get($var_name, $default='') {
		global $GRAB_TAXI_STORAGE;
		return isset($GRAB_TAXI_STORAGE[$var_name]) ? $GRAB_TAXI_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('grab_taxi_storage_set')) {
	function grab_taxi_storage_set($var_name, $value) {
		global $GRAB_TAXI_STORAGE;
		$GRAB_TAXI_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('grab_taxi_storage_empty')) {
	function grab_taxi_storage_empty($var_name, $key='', $key2='') {
		global $GRAB_TAXI_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($GRAB_TAXI_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($GRAB_TAXI_STORAGE[$var_name][$key]);
		else
			return empty($GRAB_TAXI_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('grab_taxi_storage_isset')) {
	function grab_taxi_storage_isset($var_name, $key='', $key2='') {
		global $GRAB_TAXI_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($GRAB_TAXI_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($GRAB_TAXI_STORAGE[$var_name][$key]);
		else
			return isset($GRAB_TAXI_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('grab_taxi_storage_inc')) {
	function grab_taxi_storage_inc($var_name, $value=1) {
		global $GRAB_TAXI_STORAGE;
		if (empty($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = 0;
		$GRAB_TAXI_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('grab_taxi_storage_concat')) {
	function grab_taxi_storage_concat($var_name, $value) {
		global $GRAB_TAXI_STORAGE;
		if (empty($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = '';
		$GRAB_TAXI_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('grab_taxi_storage_get_array')) {
	function grab_taxi_storage_get_array($var_name, $key, $key2='', $default='') {
		global $GRAB_TAXI_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($GRAB_TAXI_STORAGE[$var_name][$key]) ? $GRAB_TAXI_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($GRAB_TAXI_STORAGE[$var_name][$key][$key2]) ? $GRAB_TAXI_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('grab_taxi_storage_set_array')) {
	function grab_taxi_storage_set_array($var_name, $key, $value) {
		global $GRAB_TAXI_STORAGE;
		if (!isset($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = array();
		if ($key==='')
			$GRAB_TAXI_STORAGE[$var_name][] = $value;
		else
			$GRAB_TAXI_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('grab_taxi_storage_set_array2')) {
	function grab_taxi_storage_set_array2($var_name, $key, $key2, $value) {
		global $GRAB_TAXI_STORAGE;
		if (!isset($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = array();
		if (!isset($GRAB_TAXI_STORAGE[$var_name][$key])) $GRAB_TAXI_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$GRAB_TAXI_STORAGE[$var_name][$key][] = $value;
		else
			$GRAB_TAXI_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('grab_taxi_storage_merge_array')) {
	function grab_taxi_storage_merge_array($var_name, $key, $value) {
		global $GRAB_TAXI_STORAGE;
		if (!isset($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = array();
		if ($key==='')
			$GRAB_TAXI_STORAGE[$var_name] = array_merge($GRAB_TAXI_STORAGE[$var_name], $value);
		else
			$GRAB_TAXI_STORAGE[$var_name][$key] = array_merge($GRAB_TAXI_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('grab_taxi_storage_set_array_after')) {
	function grab_taxi_storage_set_array_after($var_name, $after, $key, $value='') {
		global $GRAB_TAXI_STORAGE;
		if (!isset($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = array();
		if (is_array($key))
			grab_taxi_array_insert_after($GRAB_TAXI_STORAGE[$var_name], $after, $key);
		else
			grab_taxi_array_insert_after($GRAB_TAXI_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('grab_taxi_storage_set_array_before')) {
	function grab_taxi_storage_set_array_before($var_name, $before, $key, $value='') {
		global $GRAB_TAXI_STORAGE;
		if (!isset($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = array();
		if (is_array($key))
			grab_taxi_array_insert_before($GRAB_TAXI_STORAGE[$var_name], $before, $key);
		else
			grab_taxi_array_insert_before($GRAB_TAXI_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('grab_taxi_storage_push_array')) {
	function grab_taxi_storage_push_array($var_name, $key, $value) {
		global $GRAB_TAXI_STORAGE;
		if (!isset($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($GRAB_TAXI_STORAGE[$var_name], $value);
		else {
			if (!isset($GRAB_TAXI_STORAGE[$var_name][$key])) $GRAB_TAXI_STORAGE[$var_name][$key] = array();
			array_push($GRAB_TAXI_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('grab_taxi_storage_pop_array')) {
	function grab_taxi_storage_pop_array($var_name, $key='', $defa='') {
		global $GRAB_TAXI_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($GRAB_TAXI_STORAGE[$var_name]) && is_array($GRAB_TAXI_STORAGE[$var_name]) && count($GRAB_TAXI_STORAGE[$var_name]) > 0) 
				$rez = array_pop($GRAB_TAXI_STORAGE[$var_name]);
		} else {
			if (isset($GRAB_TAXI_STORAGE[$var_name][$key]) && is_array($GRAB_TAXI_STORAGE[$var_name][$key]) && count($GRAB_TAXI_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($GRAB_TAXI_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('grab_taxi_storage_inc_array')) {
	function grab_taxi_storage_inc_array($var_name, $key, $value=1) {
		global $GRAB_TAXI_STORAGE;
		if (!isset($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = array();
		if (empty($GRAB_TAXI_STORAGE[$var_name][$key])) $GRAB_TAXI_STORAGE[$var_name][$key] = 0;
		$GRAB_TAXI_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('grab_taxi_storage_concat_array')) {
	function grab_taxi_storage_concat_array($var_name, $key, $value) {
		global $GRAB_TAXI_STORAGE;
		if (!isset($GRAB_TAXI_STORAGE[$var_name])) $GRAB_TAXI_STORAGE[$var_name] = array();
		if (empty($GRAB_TAXI_STORAGE[$var_name][$key])) $GRAB_TAXI_STORAGE[$var_name][$key] = '';
		$GRAB_TAXI_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('grab_taxi_storage_call_obj_method')) {
	function grab_taxi_storage_call_obj_method($var_name, $method, $param=null) {
		global $GRAB_TAXI_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($GRAB_TAXI_STORAGE[$var_name]) ? $GRAB_TAXI_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($GRAB_TAXI_STORAGE[$var_name]) ? $GRAB_TAXI_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('grab_taxi_storage_get_obj_property')) {
	function grab_taxi_storage_get_obj_property($var_name, $prop, $default='') {
		global $GRAB_TAXI_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($GRAB_TAXI_STORAGE[$var_name]->$prop) ? $GRAB_TAXI_STORAGE[$var_name]->$prop : $default;
	}
}
?>